local t = Def.ActorFrame {};
local song = GAMESTATE:GetCurrentSong();
local stage = GAMESTATE:GetCurrentStage();
local jkt = song:GetJacketPath();
local sname = song:GetDisplayMainTitle();
local ssname = song:GetDisplaySubTitle();
if ssname == "" then ssname = nil end
local sartist = song:GetDisplayArtist();
local cx = SCREEN_CENTER_X;
local cy = SCREEN_CENTER_Y;
t[#t+1] = Def.Quad {
	InitCommand=function(self) self:Center():FullScreen():diffuse(color("#000000")):diffusealpha(1) end;
};

t[#t+1] = LoadActor("sound_gate")..{
	InitCommand=function(self) self:sleep(0.5):queuecommand("Play") end;
	PlayCommand=function(self) self:play() end;
};

t[#t+1] = LoadActor("_2loading")..{
	InitCommand=function(self) self:sleep(1.55):queuecommand("Play") end;
	PlayCommand=function(self) self:play() end;
};

t[#t+1] = LoadActor("_exshock")..{
	InitCommand=function(self) self:sleep(3.5):queuecommand("Play") end;
	PlayCommand=function(self) self:play() end;
};

t[#t+1] = LoadActor("grid_gate")..{
	InitCommand=function(self) self:Center():diffusealpha(0):linear(0.5):diffusealpha(0.25) end;
};

t[#t+1] = LoadActor("chipcircle_gate")..{
	InitCommand=function(self) self:Center():diffusealpha(0):sleep(0.5):linear(0.2):diffusealpha(0.75):linear(0.2):diffusealpha(0.5) end;
	OnCommand=function(self) self:sleep(0.75):accelerate(2):rotationz(1440):diffusealpha(0.75):sleep(1.75):queuecommand("SpinOut") end;
	SpinOutCommand=function(self) self:accelerate(0.3):rotationz(180):linear(2.25):rotationz(1800) end;
};

t[#t+1] = LoadActor("../_jacketframe")..{
	Condition=GAMESTATE:GetCurrentSong():GetJacketPath();
	InitCommand=function(self) self:Center():zoom(0.8):diffusealpha(0):sleep(3.6):diffusealpha(1):sleep(1.5):linear(0.3):diffusealpha(0) end;
};

t[#t+1] = LoadActor(jkt)..{
	InitCommand=function(self) self:Center():diffusealpha(0) end;
	OnCommand=function(self) self:sleep(3.6):diffusealpha(1):scaletofit(cx-79,cy-79,cx+79,cy+79):sleep(1.5):linear(0.3):diffusealpha(0) end;
};

t[#t+1] = Def.ActorFrame {
	InitCommand=function(self) self:Center():addy(120):zoom(0.8):diffusealpha(0) end;
	OnCommand=function(self) self:sleep(3.6):diffusealpha(1):sleep(1.5):linear(0.3):diffusealpha(0) end;
		LoadFont("_pixellari 32px")..{
			InitCommand=function(self)
				if ssname ~= nil then -- main and sub title
					self:settextf("%s\n\n%s",sname,ssname):addy(-10):zoom(0.7)
				elseif ssname == nil then -- main title
					self:settext(sname):addy(-15):zoom(0.9)
				end
			end;
		};
		LoadFont("_pixellari 32px")..{
			InitCommand=function(self)
				if ssname then 
					self:maxwidth(700):addy(23):zoom(0.9)
				else
					self:maxwidth(700):addy(18)
				end
			end;
			OnCommand=function(self) self:settext(sartist) end;
		};
};

t[#t+1] = LoadActor("energy_gate")..{
	InitCommand=function(self) self:Center():zoom(0.5):diffusealpha(0):sleep(1.5):accelerate(2.05):zoom(1.1):diffusealpha(1):linear(0.075):zoom(6):sleep(0.1):linear(0.3):diffusealpha(0) end;
};

t[#t+1] = LoadActor("ULTRA")..{
	InitCommand=function(self) self:Center():addy(-30):addx(-550):sleep(0.25):linear(0.25):addx(550):sleep(1):linear(0.25):addx(550) end;
};

t[#t+1] = LoadActor("GATE")..{
	InitCommand=function(self) self:Center():addy(30):addx(550):sleep(0.25):linear(0.25):addx(-550):sleep(1):linear(0.25):addx(-550) end;
};

return t;